package gui.menus.file;

import gui.GenericLoader;
import gui.GraphViewerPanel;
import gui.MainFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
/**
 * @author Andrea
 *
 */
public class ResetSimulItem extends JMenuItem
{
static final long serialVersionUID = 1l;
	
	public ResetSimulItem()
	{
		super();
		initialize();
	}
	
	private void initialize()
	{
		this.setText("Clear Simulation");
		this.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N,ActionEvent.CTRL_MASK));
		this.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				/**
				 * in the following every list, table etc is resetted
				 */
				GenericLoader.resetSystem();
				MainFrame.getInstance().getStateDescriptionPanel().resetActionList();
				JTable serviceList=MainFrame.getInstance().getAvServPanel().getAvailableServiceList();
				TableModel tableModel = 
					new DefaultTableModel(
							new String[][]{{}},
							new String[] { "TS name", "State","Filename"});
				serviceList.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
				serviceList.getColumnModel().getColumn(0).setPreferredWidth(150);
				serviceList.getColumnModel().getColumn(1).setPreferredWidth(150);
				serviceList.getColumnModel().getColumn(2).setPreferredWidth(150);
				serviceList.setModel(tableModel);

				JTable serviceList1=MainFrame.getInstance().getAvServPanel().getTargetServiceList();
				TableModel tableModel1 = 
					new DefaultTableModel(
							new String[][]{{}},
							new String[] { "TS name", "State","Filename"});
				serviceList1.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
				serviceList1.getColumnModel().getColumn(0).setPreferredWidth(150);
				serviceList1.getColumnModel().getColumn(1).setPreferredWidth(150);
				serviceList1.getColumnModel().getColumn(2).setPreferredWidth(150);
				serviceList1.setModel(tableModel1);
				
				
				GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
				graphPanel.resetGraphPanel();
				
				MainFrame.getInstance().getStateDescriptionPanel().getStopSimulation().setEnabled(false);
				MainFrame.getInstance().getStateDescriptionPanel().getStartSimulation().setEnabled(false);
				MainFrame.getInstance().getStateDescriptionPanel().getActionButton().setEnabled(false);
				
				MainFrame.getInstance().getAvServPanel().getRemoveAvailableServiceButton().setEnabled(false);
				MainFrame.getInstance().getAvServPanel().getActionButton().setEnabled(false);
				MainFrame.getInstance().getAvServPanel().getActionButton1().setEnabled(false);
				
				
			}
		});
	}
}
